//
//  BIEstimateCard.h
//  BIViews
//
//  Created by Eric Hochmeister on 11/04/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MCApplication/MCWindowController.h>

@class BIProject;
@class BIEstimate;

@interface BIEstimateCard : MCWindowController {

	BOOL _createEstimateFlag;
	BIProject* _project;
	BIEstimate* _estimate;
	
	IBOutlet NSButton* showEstimatePDFButton;
	IBOutlet NSButton* cancelButton;
	IBOutlet NSButton* OKButton;
}

- (BOOL)createEstimateFlag;
- (void)setCreateEstimateFlag:(BOOL)flag;

- (BIProject *)project;
- (void)setProject:(BIProject *)aProject;
- (BIEstimate *)estimate;
- (void)setEstimate:(BIEstimate *)anEstimate;

- (void)setupEstimateCardWithEstimate:(BIEstimate*)anEstimate forProject:(BIProject*)aProject;

- (IBAction)cancel:(id)sender;
- (IBAction)saveEstimate:(id)sender;

- (NSString*)estimateTitle;
- (void)setEstimateTitle:(NSString*)aString;

- (NSString*)estimateCommentary;
- (void)setEstimateCommentary:(id)sender;

@end
